(defmeth mosaic-proto :my-new-plot 
  (cells levels  &key freq plot-values color-values (standardize  t)
         gaps way-labels level-labels show)
  (when (and freq (= (length levels) 2)) ;transpose if 2-way frequency data
        (setf cells (combine (row-list (transpose (matrix levels cells)))))
        (when color-values 
              (setf color-values 
                    (combine (row-list (transpose (matrix levels color-values))))))
        (when plot-values 
              (setf plot-values 
                    (combine (row-list (transpose (matrix levels plot-values))))))
        (setf levels (reverse levels))
        (setf level-labels (reverse level-labels))
        (setf way-labels (reverse way-labels)))
  (when color-values 
        (when (/= (length cells) (length color-values ))
              (fatal-message "When you specify color values, there must be one for each data cell.")))
  (when plot-values
        (when (/= (length plot-values) (length cells))
              (fatal-message "When you specify variable plot-values, there must be a list for each data cell.")))
  (send self :color-values 
        (if standardize 
            (if (= (length (remove-duplicates color-values)) 1)
                (repeat 0.0 (length color-values))
                (standardize color-values))
            color-values))
  (send self :shading (send self  :color-values))
  (send self :hilite-rect nil)
  (send self :brushing-info nil)
  (send self :colored-tiles nil)
  ;(setf cells (round cells))
  (send self :freq freq)
  (send self :cells cells)
  (send self :levels levels)
  (send self :ways  (length levels))
  (when (> (send self :ways) 4) 
        (fatal-message "Mosaic Plot cannot use more than 4 way data"))
  (send self :total (length cells))
  (when (not way-labels) 
        (setf way-labels 
              (mapcar #'(lambda (i) (format nil "Way~d" i))
                      (iseq (send self :ways)))))
  (send self :way-labels way-labels)
  (when (not level-labels)
        (setf level-labels 
              (mapcar #'(lambda (lab i)
                          (iseq i) ;(repeat lab i)
                          )
                      way-labels levels)))
  (setf level-labels 
        (mapcar #'(lambda (labels)
                    (if (stringp (first labels))
                        labels
                        (mapcar #'(lambda (label)
                                    (format nil "~s" label))
                                labels)
                        ))
                level-labels))
  (send self :level-labels level-labels)
  (cond
    ((and way-labels level-labels)
     (send self :to-label t))
    ((or way-labels level-labels)
     (vista-message "Axes are labeled only when both the way labels and level labels are specified.")))
  (send self :point-labels nil)
  (send self :tick-mark-labels (list nil nil))
  (send self :x-tick-mark-locs nil)
  (send self :y-tick-mark-locs nil)
  (send self :rects nil)
  (send self :standardize-shading standardize)
  (send self :gaps 
        (if (not gaps)
            (* (repeat 5 (send self :ways)) 
               (reverse (1+ (iseq (send self :ways)))))
            gaps))
  (send self :plotvalues plot-values)
  (send self :original-mx  
        (coerce (+ (send self :content-rect) '(0 0 -6 -6)) 'vector))

  (reset-graphics-buffer)
  (send self :start-buffering)
  (send self :prepare)
  (send self :range 0 0 100)
  (send self :range 1 0 100)
  (send self :add-mosaic)
  (when (send self :shading)
        (send self :colored-tiles t)
        (when (not (send self :bar))
              (send self :add-color-spectrum)))
  (send self :dynamic-tick-mark-labels 
        (send self :make-dynamic-tick-mark-labels))
  (let ((choice (position (send self :plottype) 
                          '("dotplot" "random" "qplot" "npplot") 
                          :test #'equal)))
    (when choice (send self :make-subplots (1+ choice))))
;following two statements do not work right in other order for mswin
  (send self :redraw)
  (send self :buffer-to-screen)
  
  (when show (send self :show-window))
  self)